<?xml version="1.0" encoding="UTF-8" ?>



<!--

    Document   : tree.xsl

    Created on : October 8, 2003, 10:15 AM

    Author     : andrew

    Description:

        Purpose of transformation follows.

-->



<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:output method="html"/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>

	

	<xsl:template match="/">

		<table border="0" cellpadding="0" cellspacing="0">

			<xsl:apply-templates select='/cache/cache'>

				<xsl:sort select='@urlName'/>

			</xsl:apply-templates>

		</table>

	</xsl:template>

	

	<xsl:template match='cache'>

		<tr treeId='{@id}' treeLevel='{count(ancestor::cache)}'><xsl:if test='parent::cache/parent::cache'><xsl:attribute name='style'>display:none</xsl:attribute></xsl:if>

			<td class='TreeRowTD' noWrap='true'>

				<span class='treeIndent2'>

					<xsl:for-each select='ancestor::cache[parent::cache]'>

						<span><xsl:attribute name='class'><xsl:choose><xsl:when test='following-sibling::cache'>Left</xsl:when><xsl:otherwise>Right</xsl:otherwise></xsl:choose></xsl:attribute>&#160;</span><span class='Right'>&#160;</span>

					</xsl:for-each>

					<span class='Left'>&#160;</span>

					<img class='treeStatus'><xsl:attribute name='src'>../apt/images/<xsl:choose>

						<xsl:when test='cache'>tree-plus</xsl:when>

						<xsl:otherwise>tree-leaf</xsl:otherwise>

					</xsl:choose>.gif</xsl:attribute></img>

				</span>

					<a class='titoAnchor' href='javascript:' title='{@name}'><xsl:apply-templates select='@statId'/>

						<xsl:choose><xsl:when test='@type'><img class='mimeType' src='images/types.{@type}.gif' border='0'/></xsl:when>

							<xsl:when test='parent::cache/parent::cache'><img class='mimeType' src='images/types.fn.gif' border='0'/></xsl:when>

						</xsl:choose>

						<xsl:choose><xsl:when test='@urlName'><xsl:value-of select='@urlName'/></xsl:when>

					<xsl:otherwise><xsl:value-of select='@name'/></xsl:otherwise></xsl:choose></a>

			</td>

		</tr>

		<xsl:apply-templates>

			<xsl:sort select='@name'/>

		</xsl:apply-templates>

	</xsl:template>

</xsl:stylesheet>

